Ext.data.JsonP.sol_common_ix_services_StandardPreconditions({"tagname":"class","name":"sol.common.ix.services.StandardPreconditions","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.services.StandardPreconditions.js","href":"sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions"}],"author":[{"tagname":"author","name":"MH, ELO Digital Office GmbH","email":null},{"tagname":"author","name":"PB, ELO Digital Office GmbH","email":null}],"version":["1.00.000"],"since":"1.12.000","eloix":true,"requires":["sol.common.Injection","sol.common.ObjectUtils","sol.common.Template","sol.common.ix.RfUtils","sol.common.ix.ServiceBase"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.ServiceBase","mixins":["sol.common.mixins.ElementService","sol.common.mixins.Inject","sol.common.mixins.ObjectFilter"],"uses":[],"members":[{"name":"conditions","tagname":"cfg","owner":"sol.common.ix.services.StandardPreconditions","id":"cfg-conditions","meta":{}},{"name":"notAllowedMessage","tagname":"cfg","owner":"sol.common.ix.services.StandardPreconditions","id":"cfg-notAllowedMessage","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.ServiceBase","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ix.services.StandardPreconditions","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"targetId","tagname":"cfg","owner":"sol.common.ix.services.StandardPreconditions","id":"cfg-targetId","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"inject","tagname":"property","owner":"sol.common.ix.services.StandardPreconditions","id":"property-inject","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mixin","tagname":"property","owner":"sol.common.mixins.ElementService","id":"property-mixin","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"executeElementService","tagname":"method","owner":"sol.common.mixins.ElementService","id":"method-executeElementService","meta":{"private":true}},{"name":"generateConditions","tagname":"method","owner":"sol.common.ix.services.StandardPreconditions","id":"method-generateConditions","meta":{}},{"name":"getContext","tagname":"method","owner":"sol.common.ix.services.StandardPreconditions","id":"method-getContext","meta":{"private":true}},{"name":"hasConditions","tagname":"method","owner":"sol.common.ix.services.StandardPreconditions","id":"method-hasConditions","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.mixins.ElementService","id":"method-initialize","meta":{"private":true}},{"name":"isValid","tagname":"method","owner":"sol.common.ix.services.StandardPreconditions","id":"method-isValid","meta":{"private":true}},{"name":"performElementService","tagname":"method","owner":"sol.common.ix.services.StandardPreconditions","id":"method-performElementService","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.services.StandardPreconditions","id":"method-process","meta":{}},{"name":"sanitizeElementServiceConfig","tagname":"method","owner":"sol.common.mixins.ElementService","id":"method-sanitizeElementServiceConfig","meta":{"private":true}},{"name":"translateNotAllowedMessage","tagname":"method","owner":"sol.common.ix.services.StandardPreconditions","id":"method-translateNotAllowedMessage","meta":{"private":true}},{"name":"RF_sol_common_service_StandardPreconditions","tagname":"method","owner":"sol.common.ix.services.StandardPreconditions","id":"static-method-RF_sol_common_service_StandardPreconditions","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.services.StandardPreconditions","short_doc":"Checks whether certain conditions match at the selected Sord. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><strong>sol.common.ix.services.StandardPreconditions</strong></div></div></div><h4>Mixins</h4><div class='dependency'><a href='#!/api/sol.common.mixins.ElementService' rel='sol.common.mixins.ElementService' class='docClass'>sol.common.mixins.ElementService</a></div><div class='dependency'>sol.common.mixins.Inject</div><div class='dependency'>sol.common.mixins.ObjectFilter</div><h4>Requires</h4><div class='dependency'>sol.common.Injection</div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions' target='_blank'>sol.common.ix.services.StandardPreconditions.js</a></div></pre><div class='doc-contents'><p>Checks whether certain conditions match at the selected Sord.\nBoth objKeys and mapKeys are supported.</p>\n\n<p>The Sord object is available as a TemplateSord object.\n{\n  \"objKeys\": {\n      \"MEETING_STATUS\" : \"D - Draft\"\n  },\n  \"mapKeys\": {\n      \"MEETING_TYPE\": \"Test\"\n  }\n}</p>\n\n<p>Within the conditions, the individual fields can be accessed via a JSON object path.\nFor example: objKeys.MEETING_STATUS or mapKeys.MEETING_TYPE</p>\n\n<h4>Example</h4>\n\n<pre><code>{\n  \"targetId\": \"4711\"\n  \"conditions\": [\n    { \"prop\" : \"objKeys.MEETING_STATUS\", value: \"D -*\"}\n  ],\n  \"notAllowedMessage\": \"sol.meeting.actions.createItem.notAllowed\"\n}\n</code></pre>\n\n<h4>Applying a condition with multiple condition values</h4>\n\n<pre><code>{\n  \"conditions\": [\n     { \"prop\" : \"objKeys.MEETING_STATUS\", value: [\"D -*\", \"S -*\"]}\n  ]\n}\n</code></pre>\n\n<h4>Result: Valid precondition check</h4>\n\n<pre><code>{\n  valid: true\n}\n</code></pre>\n\n<h4>Result: Invalid precondition check</h4>\n\n<p>   {\n      valid: false\n      msg: \"errorMessage\"\n   }</p>\n\n<h4>Using an elementService as data provider instead of the targetSord Object</h4>\n\n<p>   {\n      \"conditions\": [ { \"prop\": \"sords.$length\" , value: \"[^0]\"}],\n      \"elementService\": {\n           \"name\": \"RF_sol_common_service_SordProvider\",\n           \"args\": {\n                ...\n                search: [\n                   {  {\"key\": \"MEETINGTYPE_CODE\", \"value\": \"{{sord.objKeys.MEETINGTYPE_CODE}}\"} }\n                ]\n           }\n       },\n       \"options\": {\n           \"renderArgsWithElement\": true\n       }\n   }</p>\n      <p class='version-tag'>Version: <b>1.00.000</b></p>\n        <p>Available since: <b>1.12.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-conditions' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-cfg-conditions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-cfg-conditions' class='name expandable'>conditions</a> : Array&lt;Object&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='cfg-notAllowedMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-cfg-notAllowedMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-cfg-notAllowedMessage' class='name expandable'>notAllowedMessage</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional) localization key to use if the check is invalid.</p>\n</div><div class='long'><p>(optional) localization key to use if the check is invalid.</p>\n</div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;targetId&quot;, &quot;ci&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-targetId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-cfg-targetId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-cfg-targetId' class='name expandable'>targetId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>is the targetSord to check</p>\n</div><div class='long'><p>is the targetSord to check</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-inject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-property-inject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-property-inject' class='name expandable'>inject</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{targetSord: {sordIdFromProp: &quot;targetId&quot;}}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mixin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.mixins.ElementService' rel='sol.common.mixins.ElementService' class='defined-in docClass'>sol.common.mixins.ElementService</a><br/><a href='source/lib_sol.common.ElementService.html#sol-common-mixins-ElementService-property-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ElementService-property-mixin' class='name expandable'>mixin</a> : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-executeElementService' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.mixins.ElementService' rel='sol.common.mixins.ElementService' class='defined-in docClass'>sol.common.mixins.ElementService</a><br/><a href='source/lib_sol.common.ElementService.html#sol-common-mixins-ElementService-method-executeElementService' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ElementService-method-executeElementService' class='name expandable'>executeElementService</a>( <span class='pre'>cfg, templateData, options</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>templateData</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-generateConditions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-method-generateConditions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-method-generateConditions' class='name expandable'>generateConditions</a>( <span class='pre'>conditions</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>generatedConditions has same structure like foreach or sordprovider filter\n but in this context condition is better n...</div><div class='long'><p>generatedConditions has same structure like foreach or sordprovider filter\n but in this context condition is better naming for the purposes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conditions</span> : *<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>the generated filters</p>\n</div></li></ul></div></div></div><div id='method-getContext' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-method-getContext' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-method-getContext' class='name expandable'>getContext</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-hasConditions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-method-hasConditions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-method-hasConditions' class='name expandable'>hasConditions</a>( <span class='pre'>conditions</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conditions</span> : *<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.mixins.ElementService' rel='sol.common.mixins.ElementService' class='defined-in docClass'>sol.common.mixins.ElementService</a><br/><a href='source/lib_sol.common.ElementService.html#sol-common-mixins-ElementService-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ElementService-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-method-initialize\" rel=\"sol.common.ix.ServiceBase-method-initialize\" class=\"docClass\">sol.common.ix.ServiceBase.initialize</a></p></div></div></div><div id='method-isValid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-method-isValid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-method-isValid' class='name expandable'>isValid</a>( <span class='pre'>sord, conditions</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>conditions</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-performElementService' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-method-performElementService' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-method-performElementService' class='name expandable'>performElementService</a>( <span class='pre'>elementServiceCfg, templateData, options</span> ) : {sords:Array&lt;Object&gt;}<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>elementServiceCfg</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>templateData</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>{sords:Array&lt;Object&gt;}</span><div class='sub-desc'><p>elements</p>\n</div></li></ul></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-method-process' class='name expandable'>process</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Performes the checks and retrieves the data as spezified in the configuration. ...</div><div class='long'><p>Performes the checks and retrieves the data as spezified in the configuration.</p>\n\n<p>Returns the value in the format:\n  {\n    valid: Boolean,\n    message: String\n  }</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-method-process\" rel=\"sol.common.ix.ServiceBase-method-process\" class=\"docClass\">sol.common.ix.ServiceBase.process</a></p></div></div></div><div id='method-sanitizeElementServiceConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.mixins.ElementService' rel='sol.common.mixins.ElementService' class='defined-in docClass'>sol.common.mixins.ElementService</a><br/><a href='source/lib_sol.common.ElementService.html#sol-common-mixins-ElementService-method-sanitizeElementServiceConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.mixins.ElementService-method-sanitizeElementServiceConfig' class='name expandable'>sanitizeElementServiceConfig</a>( <span class='pre'>opt</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>opt</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-translateNotAllowedMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-method-translateNotAllowedMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-method-translateNotAllowedMessage' class='name expandable'>translateNotAllowedMessage</a>( <span class='pre'>message</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>message</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_service_StandardPreconditions' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.StandardPreconditions'>sol.common.ix.services.StandardPreconditions</span><br/><a href='source/sol.common.ix.services.StandardPreconditions.html#sol-common-ix-services-StandardPreconditions-static-method-RF_sol_common_service_StandardPreconditions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.StandardPreconditions-static-method-RF_sol_common_service_StandardPreconditions' class='name expandable'>RF_sol_common_service_StandardPreconditions</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});